/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Enumerated;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DEREnumerated;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.x509.AccessDescription;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityInformationAccess;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.BasicConstraints;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralSubtree;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.NameConstraints;
import com.timevale.tgtext.bouncycastle.asn1.x509.PolicyInformation;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.qualified.MonetaryValue;
import com.timevale.tgtext.bouncycastle.asn1.x509.qualified.QCStatement;
import com.timevale.tgtext.bouncycastle.i18n.ErrorBundle;
import com.timevale.tgtext.bouncycastle.i18n.LocaleString;
import com.timevale.tgtext.bouncycastle.i18n.filter.TrustedInput;
import com.timevale.tgtext.bouncycastle.i18n.filter.UntrustedInput;
import com.timevale.tgtext.bouncycastle.i18n.filter.UntrustedUrlInput;
import com.timevale.tgtext.bouncycastle.jce.provider.AnnotatedException;
import com.timevale.tgtext.bouncycastle.jce.provider.CertPathValidatorUtilities;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXPolicyNode;
import com.timevale.tgtext.bouncycastle.util.Integers;
import com.timevale.tgtext.bouncycastle.x509.CertPathReviewerException;
import com.timevale.tgtext.bouncycastle.x509.X509CRLStoreSelector;
import com.timevale.tgtext.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = X509Extensions.QCStatements.getId();
    private static final String CRL_DIST_POINTS = X509Extensions.CRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "com.timevale.tgtext.bouncycastle.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters params) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)params.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate(this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters params) throws CertPathReviewerException {
        this.init(certPath, params);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int index) {
        this.doChecks();
        return this.errors[index + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int index) {
        this.doChecks();
        return this.notifications[index + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean valid = true;
        for (int i2 = 0; i2 < this.errors.length; ++i2) {
            if (this.errors[i2].isEmpty()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected void addNotification(ErrorBundle msg) {
        this.notifications[0].add(msg);
    }

    protected void addNotification(ErrorBundle msg, int index) {
        if (index < -1 || index >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[index + 1].add(msg);
    }

    protected void addError(ErrorBundle msg) {
        this.errors[0].add(msg);
    }

    protected void addError(ErrorBundle msg, int index) {
        if (index < -1 || index >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[index + 1].add(msg);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i2 = 0; i2 < this.notifications.length; ++i2) {
                this.notifications[i2] = new ArrayList();
                this.errors[i2] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        PKIXNameConstraintValidator nameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int index = this.certs.size() - 1; index > 0; --index) {
                GeneralSubtree[] excluded;
                ASN1Sequence ncSeq;
                X509Certificate cert = (X509Certificate)this.certs.get(index);
                if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                    ASN1Sequence altName;
                    ASN1Sequence dns;
                    X500Principal principal = PKIXCertPathReviewer.getSubjectPrincipal(cert);
                    ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(principal.getEncoded()));
                    try {
                        dns = (ASN1Sequence)aIn.readObject();
                    }
                    catch (IOException e2) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(principal)});
                        throw new CertPathReviewerException(msg, (Throwable)e2, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkPermittedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkExcludedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    try {
                        altName = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException ae2) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException(msg, (Throwable)ae2, this.certPath, index);
                    }
                    if (altName != null) {
                        for (int j2 = 0; j2 < altName.size(); ++j2) {
                            GeneralName name = GeneralName.getInstance(altName.getObjectAt(j2));
                            try {
                                nameConstraintValidator.checkPermitted(name);
                                nameConstraintValidator.checkExcluded(name);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException cpve) {
                                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(name)});
                                throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                            }
                        }
                    }
                }
                try {
                    ncSeq = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException ae3) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException(msg, (Throwable)ae3, this.certPath, index);
                }
                if (ncSeq == null) continue;
                NameConstraints nc = NameConstraints.getInstance(ncSeq);
                GeneralSubtree[] permitted = nc.getPermittedSubtrees();
                if (permitted != null) {
                    nameConstraintValidator.intersectPermittedSubtree(permitted);
                }
                if ((excluded = nc.getExcludedSubtrees()) == null) continue;
                for (int c2 = 0; c2 != excluded.length; ++c2) {
                    nameConstraintValidator.addExcludedSubtree(excluded[c2]);
                }
            }
            return;
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
            return;
        }
    }

    private void checkPathLength() {
        int maxPathLength = this.n;
        int totalPathLength = 0;
        for (int index = this.certs.size() - 1; index > 0; --index) {
            int _plc;
            BigInteger _pathLengthConstraint;
            BasicConstraints bc2;
            X509Certificate cert = (X509Certificate)this.certs.get(index);
            if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                if (maxPathLength <= 0) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLenghtExtended");
                    this.addError(msg);
                }
                --maxPathLength;
                ++totalPathLength;
            }
            try {
                bc2 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(msg, index);
                bc2 = null;
            }
            if (bc2 == null || (_pathLengthConstraint = bc2.getPathLenConstraint()) == null || (_plc = _pathLengthConstraint.intValue()) >= maxPathLength) continue;
            maxPathLength = _plc;
        }
        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf(totalPathLength)});
        this.addNotification(msg);
    }

    private void checkSignatures() {
        AlgorithmIdentifier workingAlgId;
        ErrorBundle msg;
        TrustAnchor trust = null;
        X500Principal trustPrincipal = null;
        ErrorBundle msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput(this.validDate), new TrustedInput(new Date())});
        this.addNotification(msg2);
        try {
            X509Certificate cert = (X509Certificate)this.certs.get(this.certs.size() - 1);
            Collection trustColl = this.getTrustAnchors(cert, this.pkixParams.getTrustAnchors());
            if (trustColl.size() > 1) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf(trustColl.size()), new UntrustedInput(cert.getIssuerX500Principal())});
                this.addError(msg);
            } else if (trustColl.isEmpty()) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(cert.getIssuerX500Principal()), Integers.valueOf(this.pkixParams.getTrustAnchors().size())});
                this.addError(msg);
            } else {
                trust = (TrustAnchor)trustColl.iterator().next();
                PublicKey trustPublicKey = trust.getTrustedCert() != null ? trust.getTrustedCert().getPublicKey() : trust.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, trustPublicKey, this.pkixParams.getSigProvider());
                }
                catch (SignatureException signatureException) {
                    ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError(msg3);
                }
                catch (Exception exception) {}
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage());
        }
        catch (Throwable t2) {
            ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknown", new Object[]{new UntrustedInput(t2.getMessage()), new UntrustedInput(t2)});
            this.addError(msg4);
        }
        if (trust != null) {
            boolean[] ku;
            X509Certificate sign = trust.getTrustedCert();
            try {
                trustPrincipal = sign != null ? PKIXCertPathReviewer.getSubjectPrincipal(sign) : new X500Principal(trust.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trust.getCAName())});
                this.addError(msg);
            }
            if (sign != null && (ku = sign.getKeyUsage()) != null && !ku[5]) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustKeyUsage");
                this.addNotification(msg);
            }
        }
        PublicKey workingPublicKey = null;
        X500Principal workingIssuerName = trustPrincipal;
        X509Certificate sign = null;
        if (trust != null) {
            sign = trust.getTrustedCert();
            workingPublicKey = sign != null ? sign.getPublicKey() : trust.getCAPublicKey();
            try {
                workingAlgId = PKIXCertPathReviewer.getAlgorithmIdentifier(workingPublicKey);
                workingAlgId.getObjectId();
                workingAlgId.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(msg5);
            }
        }
        for (int index = this.certs.size() - 1; index >= 0; --index) {
            ErrorBundle msg6;
            ErrorBundle msg7;
            ErrorBundle msg8;
            int i2 = this.n - index;
            X509Certificate cert = (X509Certificate)this.certs.get(index);
            if (workingPublicKey != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, workingPublicKey, this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException ex2) {
                    msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex2.getMessage(), ex2, ex2.getClass().getName()});
                    this.addError(msg8, index);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued(cert)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, cert.getPublicKey(), this.pkixParams.getSigProvider());
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError(msg7, index);
                }
                catch (GeneralSecurityException ex3) {
                    msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex3.getMessage(), ex3, ex3.getClass().getName()});
                    this.addError(msg8, index);
                }
            } else {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                byte[] akiBytes = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (akiBytes != null) {
                    try {
                        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance(X509ExtensionUtil.fromExtensionValue(akiBytes));
                        GeneralNames issuerNames = aki.getAuthorityCertIssuer();
                        if (issuerNames != null) {
                            GeneralName name = issuerNames.getNames()[0];
                            BigInteger serial = aki.getAuthorityCertSerialNumber();
                            if (serial != null) {
                                Object[] extraArgs = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", name, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", serial};
                                msg7.setExtraArguments(extraArgs);
                            }
                        }
                    }
                    catch (IOException iOException) {}
                }
                this.addError(msg7, index);
            }
            try {
                cert.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput(cert.getNotBefore())});
                this.addError(msg8, index);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput(cert.getNotAfter())});
                this.addError(msg8, index);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                ErrorBundle msg9;
                CRLDistPoint crlDistPoints = null;
                try {
                    ASN1Primitive crl_dp = PKIXCertPathReviewer.getExtensionValue(cert, CRL_DIST_POINTS);
                    if (crl_dp != null) {
                        crlDistPoints = CRLDistPoint.getInstance(crl_dp);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPtExtError");
                    this.addError(msg6, index);
                }
                AuthorityInformationAccess authInfoAcc = null;
                try {
                    ASN1Primitive auth_info_acc = PKIXCertPathReviewer.getExtensionValue(cert, AUTH_INFO_ACCESS);
                    if (auth_info_acc != null) {
                        authInfoAcc = AuthorityInformationAccess.getInstance(auth_info_acc);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle msg10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlAuthInfoAccError");
                    this.addError(msg10, index);
                }
                Vector crlDistPointUrls = this.getCRLDistUrls(crlDistPoints);
                Vector ocspUrls = this.getOCSPUrls(authInfoAcc);
                Iterator urlIt = crlDistPointUrls.iterator();
                while (urlIt.hasNext()) {
                    msg9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(urlIt.next())});
                    this.addNotification(msg9, index);
                }
                urlIt = ocspUrls.iterator();
                while (urlIt.hasNext()) {
                    msg9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(urlIt.next())});
                    this.addNotification(msg9, index);
                }
                try {
                    this.checkRevocation(this.pkixParams, cert, this.validDate, sign, workingPublicKey, crlDistPointUrls, ocspUrls, index);
                }
                catch (CertPathReviewerException cpre) {
                    this.addError(cpre.getErrorMessage(), index);
                }
            }
            if (workingIssuerName != null && !cert.getIssuerX500Principal().equals(workingIssuerName)) {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{workingIssuerName.getName(), cert.getIssuerX500Principal().getName()});
                this.addError(msg7, index);
            }
            if (i2 != this.n) {
                if (cert != null && cert.getVersion() == 1) {
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError(msg7, index);
                }
                try {
                    BasicConstraints bc2 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, BASIC_CONSTRAINTS));
                    if (bc2 != null) {
                        if (!bc2.isCA()) {
                            msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError(msg8, index);
                        }
                    } else {
                        msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError(msg8, index);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError(msg6, index);
                }
                boolean[] _usage = cert.getKeyUsage();
                if (_usage != null && !_usage[5]) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError(msg6, index);
                }
            }
            sign = cert;
            workingIssuerName = cert.getSubjectX500Principal();
            try {
                workingPublicKey = PKIXCertPathReviewer.getNextWorkingKey(this.certs, index);
                workingAlgId = PKIXCertPathReviewer.getAlgorithmIdentifier(workingPublicKey);
                workingAlgId.getObjectId();
                workingAlgId.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError(msg8, index);
            }
        }
        this.trustAnchor = trust;
        this.subjectPublicKey = workingPublicKey;
    }

    private void checkPolicy() {
        Set<String> userInitialPolicySet = this.pkixParams.getInitialPolicies();
        List[] policyNodes = new ArrayList[this.n + 1];
        for (int j2 = 0; j2 < policyNodes.length; ++j2) {
            policyNodes[j2] = new ArrayList();
        }
        HashSet<String> policySet = new HashSet<String>();
        policySet.add("2.5.29.32.0");
        PKIXPolicyNode validPolicyTree = new PKIXPolicyNode(new ArrayList(), 0, policySet, null, new HashSet(), "2.5.29.32.0", false);
        policyNodes[0].add(validPolicyTree);
        int explicitPolicy = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int inhibitAnyPolicy = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int policyMapping = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        HashSet<String> acceptablePolicies = null;
        X509Certificate cert = null;
        try {
            HashSet _validPolicyNodeSet;
            PKIXPolicyNode intersection;
            ErrorBundle msg;
            int index;
            for (index = this.certs.size() - 1; index >= 0; --index) {
                ASN1Sequence mappings;
                ASN1Primitive pm;
                ErrorBundle msg2;
                ASN1Sequence certPolicies;
                int i2 = this.n - index;
                cert = (X509Certificate)this.certs.get(index);
                try {
                    certPolicies = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException ae2) {
                    ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException(msg3, (Throwable)ae2, this.certPath, index);
                }
                if (certPolicies != null && validPolicyTree != null) {
                    PolicyInformation pInfo;
                    Enumeration e2 = certPolicies.getObjects();
                    HashSet<String> pols = new HashSet<String>();
                    while (e2.hasMoreElements()) {
                        Set pq;
                        pInfo = PolicyInformation.getInstance(e2.nextElement());
                        ASN1ObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                        pols.add(pOid.getId());
                        if ("2.5.29.32.0".equals(pOid.getId())) continue;
                        try {
                            pq = PKIXCertPathReviewer.getQualifierSet(pInfo.getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException cpve) {
                            msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException(msg2, (Throwable)cpve, this.certPath, index);
                        }
                        boolean match = PKIXCertPathReviewer.processCertD1i(i2, policyNodes, pOid, pq);
                        if (match) continue;
                        PKIXCertPathReviewer.processCertD1ii(i2, policyNodes, pOid, pq);
                    }
                    if (acceptablePolicies == null || acceptablePolicies.contains("2.5.29.32.0")) {
                        acceptablePolicies = pols;
                    } else {
                        Iterator it = acceptablePolicies.iterator();
                        HashSet t1 = new HashSet();
                        while (it.hasNext()) {
                            Object o2 = it.next();
                            if (!pols.contains(o2)) continue;
                            t1.add(o2);
                        }
                        acceptablePolicies = t1;
                    }
                    if (inhibitAnyPolicy > 0 || i2 < this.n && PKIXCertPathReviewer.isSelfIssued(cert)) {
                        e2 = certPolicies.getObjects();
                        while (e2.hasMoreElements()) {
                            Set _apq;
                            pInfo = PolicyInformation.getInstance(e2.nextElement());
                            if (!"2.5.29.32.0".equals(pInfo.getPolicyIdentifier().getId())) continue;
                            try {
                                _apq = PKIXCertPathReviewer.getQualifierSet(pInfo.getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException cpve) {
                                ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(msg4, (Throwable)cpve, this.certPath, index);
                            }
                            List _nodes = policyNodes[i2 - 1];
                            for (int k2 = 0; k2 < _nodes.size(); ++k2) {
                                PKIXPolicyNode _node = (PKIXPolicyNode)_nodes.get(k2);
                                for (Object _tmp : _node.getExpectedPolicies()) {
                                    String _policy;
                                    if (_tmp instanceof String) {
                                        _policy = (String)_tmp;
                                    } else {
                                        if (!(_tmp instanceof DERObjectIdentifier)) continue;
                                        _policy = ((DERObjectIdentifier)_tmp).getId();
                                    }
                                    boolean _found = false;
                                    Iterator _childrenIter = _node.getChildren();
                                    while (_childrenIter.hasNext()) {
                                        PKIXPolicyNode _child = (PKIXPolicyNode)_childrenIter.next();
                                        if (!_policy.equals(_child.getValidPolicy())) continue;
                                        _found = true;
                                    }
                                    if (_found) continue;
                                    HashSet<String> _newChildExpectedPolicies = new HashSet<String>();
                                    _newChildExpectedPolicies.add(_policy);
                                    PKIXPolicyNode _newChild = new PKIXPolicyNode(new ArrayList(), i2, _newChildExpectedPolicies, _node, _apq, _policy, false);
                                    _node.addChild(_newChild);
                                    policyNodes[i2].add(_newChild);
                                }
                            }
                        }
                    }
                    for (int j3 = i2 - 1; j3 >= 0; --j3) {
                        PKIXPolicyNode node;
                        List nodes = policyNodes[j3];
                        for (int k3 = 0; k3 < nodes.size() && ((node = (PKIXPolicyNode)nodes.get(k3)).hasChildren() || (validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node)) != null); ++k3) {
                        }
                    }
                    Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
                    if (criticalExtensionOids != null) {
                        boolean critical = criticalExtensionOids.contains(CERTIFICATE_POLICIES);
                        List nodes = policyNodes[i2];
                        for (int j4 = 0; j4 < nodes.size(); ++j4) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(j4);
                            node.setCritical(critical);
                        }
                    }
                }
                if (certPolicies == null) {
                    validPolicyTree = null;
                }
                if (explicitPolicy <= 0 && validPolicyTree == null) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException(msg);
                }
                if (i2 == this.n) continue;
                try {
                    pm = PKIXCertPathReviewer.getExtensionValue(cert, POLICY_MAPPINGS);
                }
                catch (AnnotatedException ae3) {
                    ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(msg5, (Throwable)ae3, this.certPath, index);
                }
                if (pm != null) {
                    mappings = (ASN1Sequence)pm;
                    for (int j5 = 0; j5 < mappings.size(); ++j5) {
                        ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j5);
                        DERObjectIdentifier ip_id = (DERObjectIdentifier)mapping.getObjectAt(0);
                        DERObjectIdentifier sp_id = (DERObjectIdentifier)mapping.getObjectAt(1);
                        if ("2.5.29.32.0".equals(ip_id.getId())) {
                            msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException(msg2, this.certPath, index);
                        }
                        if (!"2.5.29.32.0".equals(sp_id.getId())) continue;
                        msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException(msg2, this.certPath, index);
                    }
                }
                if (pm != null) {
                    mappings = (ASN1Sequence)pm;
                    HashMap m_idp = new HashMap();
                    HashSet<String> s_idp = new HashSet<String>();
                    for (int j6 = 0; j6 < mappings.size(); ++j6) {
                        Set<String> tmp;
                        ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j6);
                        String id_p = ((DERObjectIdentifier)mapping.getObjectAt(0)).getId();
                        String sd_p = ((DERObjectIdentifier)mapping.getObjectAt(1)).getId();
                        if (!m_idp.containsKey(id_p)) {
                            tmp = new HashSet<String>();
                            tmp.add(sd_p);
                            m_idp.put(id_p, tmp);
                            s_idp.add(id_p);
                            continue;
                        }
                        tmp = (Set)m_idp.get(id_p);
                        tmp.add(sd_p);
                    }
                    for (String id_p : s_idp) {
                        if (policyMapping > 0) {
                            ErrorBundle msg6;
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1(i2, policyNodes, id_p, m_idp, cert);
                                continue;
                            }
                            catch (AnnotatedException ae4) {
                                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException(msg6, (Throwable)ae4, this.certPath, index);
                            }
                            catch (CertPathValidatorException cpve) {
                                msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(msg6, (Throwable)cpve, this.certPath, index);
                            }
                        }
                        if (policyMapping > 0) continue;
                        validPolicyTree = PKIXCertPathReviewer.prepareNextCertB2(i2, policyNodes, id_p, validPolicyTree);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                    if (explicitPolicy != 0) {
                        --explicitPolicy;
                    }
                    if (policyMapping != 0) {
                        --policyMapping;
                    }
                    if (inhibitAnyPolicy != 0) {
                        --inhibitAnyPolicy;
                    }
                }
                try {
                    ASN1Sequence pc = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, POLICY_CONSTRAINTS);
                    if (pc != null) {
                        Enumeration policyConstraints = pc.getObjects();
                        while (policyConstraints.hasMoreElements()) {
                            ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                            switch (constraint.getTagNo()) {
                                case 0: {
                                    int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                    if (tmpInt >= explicitPolicy) break;
                                    explicitPolicy = tmpInt;
                                    break;
                                }
                                case 1: {
                                    int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                    if (tmpInt >= policyMapping) break;
                                    policyMapping = tmpInt;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(msg7, this.certPath, index);
                }
                try {
                    int _inhibitAnyPolicy;
                    DERInteger iap = (DERInteger)PKIXCertPathReviewer.getExtensionValue(cert, INHIBIT_ANY_POLICY);
                    if (iap == null || (_inhibitAnyPolicy = iap.getValue().intValue()) >= inhibitAnyPolicy) continue;
                    inhibitAnyPolicy = _inhibitAnyPolicy;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(msg8, this.certPath, index);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(cert) && explicitPolicy > 0) {
                --explicitPolicy;
            }
            try {
                ASN1Sequence pc = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, POLICY_CONSTRAINTS);
                if (pc != null) {
                    Enumeration policyConstraints = pc.getObjects();
                    while (policyConstraints.hasMoreElements()) {
                        ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                        switch (constraint.getTagNo()) {
                            case 0: {
                                int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                if (tmpInt != 0) break;
                                explicitPolicy = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException(msg, this.certPath, index);
            }
            if (validPolicyTree == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException(msg, this.certPath, index);
                }
                intersection = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(userInitialPolicySet)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (acceptablePolicies.isEmpty()) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException(msg, this.certPath, index);
                    }
                    _validPolicyNodeSet = new HashSet();
                    for (int j7 = 0; j7 < policyNodes.length; ++j7) {
                        ArrayList _nodeDepth = policyNodes[j7];
                        for (int k4 = 0; k4 < _nodeDepth.size(); ++k4) {
                            PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k4);
                            if (!"2.5.29.32.0".equals(_node.getValidPolicy())) continue;
                            Iterator _iter = _node.getChildren();
                            while (_iter.hasNext()) {
                                _validPolicyNodeSet.add(_iter.next());
                            }
                        }
                    }
                    for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                        String _validPolicy = _node.getValidPolicy();
                        acceptablePolicies.contains(_validPolicy);
                    }
                    if (validPolicyTree != null) {
                        for (int j8 = this.n - 1; j8 >= 0; --j8) {
                            List nodes = policyNodes[j8];
                            for (int k5 = 0; k5 < nodes.size(); ++k5) {
                                PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k5);
                                if (node.hasChildren()) continue;
                                validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node);
                            }
                        }
                    }
                }
                intersection = validPolicyTree;
            } else {
                _validPolicyNodeSet = new HashSet();
                for (int j9 = 0; j9 < policyNodes.length; ++j9) {
                    ArrayList _nodeDepth = policyNodes[j9];
                    for (int k6 = 0; k6 < _nodeDepth.size(); ++k6) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k6);
                        if (!"2.5.29.32.0".equals(_node.getValidPolicy())) continue;
                        Iterator _iter = _node.getChildren();
                        while (_iter.hasNext()) {
                            PKIXPolicyNode _c_node = (PKIXPolicyNode)_iter.next();
                            if ("2.5.29.32.0".equals(_c_node.getValidPolicy())) continue;
                            _validPolicyNodeSet.add(_c_node);
                        }
                    }
                }
                for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                    String _validPolicy = _node.getValidPolicy();
                    if (userInitialPolicySet.contains(_validPolicy)) continue;
                    validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, _node);
                }
                if (validPolicyTree != null) {
                    for (int j10 = this.n - 1; j10 >= 0; --j10) {
                        ArrayList nodes = policyNodes[j10];
                        for (int k7 = 0; k7 < nodes.size(); ++k7) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k7);
                            if (node.hasChildren()) continue;
                            validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node);
                        }
                    }
                }
                intersection = validPolicyTree;
            }
            if (explicitPolicy <= 0 && intersection == null) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException(msg);
            }
            return;
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
            return;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> pathCheckers = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> certIter = pathCheckers.iterator();
        try {
            try {
                while (certIter.hasNext()) {
                    certIter.next().init(false);
                }
            }
            catch (CertPathValidatorException cpve) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{cpve.getMessage(), cpve, cpve.getClass().getName()});
                throw new CertPathReviewerException(msg, (Throwable)cpve);
            }
            for (int index = this.certs.size() - 1; index >= 0; --index) {
                X509Certificate cert = (X509Certificate)this.certs.get(index);
                Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
                if (criticalExtensions == null || criticalExtensions.isEmpty()) continue;
                criticalExtensions.remove(KEY_USAGE);
                criticalExtensions.remove(CERTIFICATE_POLICIES);
                criticalExtensions.remove(POLICY_MAPPINGS);
                criticalExtensions.remove(INHIBIT_ANY_POLICY);
                criticalExtensions.remove(ISSUING_DISTRIBUTION_POINT);
                criticalExtensions.remove(DELTA_CRL_INDICATOR);
                criticalExtensions.remove(POLICY_CONSTRAINTS);
                criticalExtensions.remove(BASIC_CONSTRAINTS);
                criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
                criticalExtensions.remove(NAME_CONSTRAINTS);
                if (criticalExtensions.contains(QC_STATEMENT) && this.processQcStatements(cert, index)) {
                    criticalExtensions.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> tmpIter = pathCheckers.iterator();
                while (tmpIter.hasNext()) {
                    try {
                        tmpIter.next().check(cert, criticalExtensions);
                    }
                    catch (CertPathValidatorException e2) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{e2.getMessage(), e2, e2.getClass().getName()});
                        throw new CertPathReviewerException(msg, e2.getCause(), this.certPath, index);
                    }
                }
                if (criticalExtensions.isEmpty()) continue;
                Iterator<String> it = criticalExtensions.iterator();
                while (it.hasNext()) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{new DERObjectIdentifier(it.next())});
                    this.addError(msg, index);
                }
            }
            return;
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
            return;
        }
    }

    private boolean processQcStatements(X509Certificate cert, int index) {
        try {
            boolean unknownStatement = false;
            ASN1Sequence qcSt = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, QC_STATEMENT);
            for (int j2 = 0; j2 < qcSt.size(); ++j2) {
                ErrorBundle msg;
                QCStatement stmt = QCStatement.getInstance(qcSt.getObjectAt(j2));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals(stmt.getStatementId())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification(msg, index);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals(stmt.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals(stmt.getStatementId())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                    this.addNotification(msg, index);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals(stmt.getStatementId())) {
                    MonetaryValue limit = MonetaryValue.getInstance(stmt.getStatementInfo());
                    limit.getCurrency();
                    double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
                    ErrorBundle msg2 = limit.getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{limit.getCurrency().getAlphabetic(), new TrustedInput(new Double(value)), limit}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf(limit.getCurrency().getNumeric()), new TrustedInput(new Double(value)), limit});
                    this.addNotification(msg2, index);
                    continue;
                }
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{stmt.getStatementId(), new UntrustedInput(stmt)});
                this.addNotification(msg, index);
                unknownStatement = true;
            }
            return !unknownStatement;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(msg, index);
            return false;
        }
    }

    private String IPtoString(byte[] ip) {
        String result;
        try {
            result = InetAddress.getByAddress(ip).getHostAddress();
        }
        catch (Exception exception) {
            StringBuffer b2 = new StringBuffer();
            for (int i2 = 0; i2 != ip.length; ++i2) {
                b2.append(Integer.toHexString(ip[i2] & 0xFF));
                b2.append(' ');
            }
            result = b2.toString();
        }
        return result;
    }

    protected void checkRevocation(PKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, Vector crlDistPointUrls, Vector ocspUrls, int index) throws CertPathReviewerException {
        this.checkCRLs(paramsPKIX, cert, validDate, sign, workingPublicKey, crlDistPointUrls, index);
    }

    protected void checkCRLs(PKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, Vector crlDistPointUrls, int index) throws CertPathReviewerException {
        ErrorBundle msg;
        ErrorBundle msg2;
        Iterator crl_iter;
        X509CRLStoreSelector crlselect = new X509CRLStoreSelector();
        try {
            crlselect.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert).getEncoded());
        }
        catch (IOException e2) {
            ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(msg3, (Throwable)e2);
        }
        crlselect.setCertificateChecking(cert);
        try {
            Set crl_coll = CRL_UTIL.findCRLs(crlselect, paramsPKIX);
            crl_iter = crl_coll.iterator();
            if (crl_coll.isEmpty()) {
                crl_coll = CRL_UTIL.findCRLs(new X509CRLStoreSelector(), paramsPKIX);
                Iterator it = crl_coll.iterator();
                ArrayList<X500Principal> nonMatchingCrlNames = new ArrayList<X500Principal>();
                while (it.hasNext()) {
                    nonMatchingCrlNames.add(((X509CRL)it.next()).getIssuerX500Principal());
                }
                int numbOfCrls = nonMatchingCrlNames.size();
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(crlselect.getIssuerNames()), new UntrustedInput(nonMatchingCrlNames), Integers.valueOf(numbOfCrls)});
                this.addNotification(msg2, index);
            }
        }
        catch (AnnotatedException ae2) {
            ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError", new Object[]{ae2.getCause().getMessage(), ae2.getCause(), ae2.getCause().getClass().getName()});
            this.addError(msg4, index);
            crl_iter = new ArrayList().iterator();
        }
        boolean validCrlFound = false;
        X509CRL crl = null;
        while (crl_iter.hasNext()) {
            ErrorBundle msg5;
            crl = (X509CRL)crl_iter.next();
            if (crl.getNextUpdate() == null || paramsPKIX.getDate().before(crl.getNextUpdate())) {
                validCrlFound = true;
                msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localValidCRL", new Object[]{new TrustedInput(crl.getThisUpdate()), new TrustedInput(crl.getNextUpdate())});
                this.addNotification(msg5, index);
                break;
            }
            msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localInvalidCRL", new Object[]{new TrustedInput(crl.getThisUpdate()), new TrustedInput(crl.getNextUpdate())});
            this.addNotification(msg5, index);
        }
        if (!validCrlFound) {
            Iterator urlIt = crlDistPointUrls.iterator();
            while (urlIt.hasNext()) {
                try {
                    String location = (String)urlIt.next();
                    X509CRL onlineCRL = this.getCRL(location);
                    if (onlineCRL == null) continue;
                    if (!cert.getIssuerX500Principal().equals(onlineCRL.getIssuerX500Principal())) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput(onlineCRL.getIssuerX500Principal().getName()), new UntrustedInput(cert.getIssuerX500Principal().getName()), new UntrustedUrlInput(location)});
                        this.addNotification(msg, index);
                        continue;
                    }
                    if (onlineCRL.getNextUpdate() == null || this.pkixParams.getDate().before(onlineCRL.getNextUpdate())) {
                        validCrlFound = true;
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineValidCRL", new Object[]{new TrustedInput(onlineCRL.getThisUpdate()), new TrustedInput(onlineCRL.getNextUpdate()), new UntrustedUrlInput(location)});
                        this.addNotification(msg, index);
                        crl = onlineCRL;
                        break;
                    }
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineInvalidCRL", new Object[]{new TrustedInput(onlineCRL.getThisUpdate()), new TrustedInput(onlineCRL.getNextUpdate()), new UntrustedUrlInput(location)});
                    this.addNotification(msg, index);
                }
                catch (CertPathReviewerException cpre) {
                    this.addNotification(cpre.getErrorMessage(), index);
                }
            }
        }
        if (crl != null) {
            ErrorBundle msg6;
            ASN1Primitive dci;
            ASN1Primitive idp;
            ErrorBundle msg7;
            boolean[] keyusage;
            if (!(sign == null || (keyusage = sign.getKeyUsage()) == null || keyusage.length >= 7 && keyusage[6])) {
                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException(msg2);
            }
            if (workingPublicKey != null) {
                try {
                    crl.verify(workingPublicKey, "BC");
                }
                catch (Exception e3) {
                    msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException(msg2, (Throwable)e3);
                }
            } else {
                ErrorBundle msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(msg8);
            }
            X509CRLEntry crl_entry = crl.getRevokedCertificate(cert.getSerialNumber());
            if (crl_entry != null) {
                String reason = null;
                if (crl_entry.hasExtensions()) {
                    ASN1Enumerated reasonCode;
                    try {
                        reasonCode = DEREnumerated.getInstance(PKIXCertPathReviewer.getExtensionValue(crl_entry, X509Extensions.ReasonCode.getId()));
                    }
                    catch (AnnotatedException ae3) {
                        ErrorBundle msg9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException(msg9, (Throwable)ae3);
                    }
                    if (reasonCode != null) {
                        reason = crlReasons[reasonCode.getValue().intValue()];
                    }
                }
                if (reason == null) {
                    reason = crlReasons[7];
                }
                LocaleString ls = new LocaleString(RESOURCE_NAME, reason);
                if (!validDate.before(crl_entry.getRevocationDate())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certRevoked", new Object[]{new TrustedInput(crl_entry.getRevocationDate()), ls});
                    throw new CertPathReviewerException(msg);
                }
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput(crl_entry.getRevocationDate()), ls});
                this.addNotification(msg, index);
            } else {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notRevoked");
                this.addNotification(msg7, index);
            }
            if (crl.getNextUpdate() != null && crl.getNextUpdate().before(this.pkixParams.getDate())) {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput(crl.getNextUpdate())});
                this.addNotification(msg7, index);
            }
            try {
                idp = PKIXCertPathReviewer.getExtensionValue(crl, ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException(msg);
            }
            try {
                dci = PKIXCertPathReviewer.getExtensionValue(crl, DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle msg10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException(msg10);
            }
            if (dci != null) {
                Iterator it;
                X509CRLStoreSelector baseSelect = new X509CRLStoreSelector();
                try {
                    baseSelect.addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal(crl).getEncoded());
                }
                catch (IOException e4) {
                    ErrorBundle msg11 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(msg11, (Throwable)e4);
                }
                baseSelect.setMinCRLNumber(((DERInteger)dci).getPositiveValue());
                try {
                    baseSelect.setMaxCRLNumber(((DERInteger)PKIXCertPathReviewer.getExtensionValue(crl, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException ae4) {
                    ErrorBundle msg12 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(msg12, (Throwable)ae4);
                }
                boolean foundBase = false;
                try {
                    it = CRL_UTIL.findCRLs(baseSelect, paramsPKIX).iterator();
                }
                catch (AnnotatedException ae5) {
                    ErrorBundle msg13 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(msg13, (Throwable)ae5);
                }
                while (it.hasNext()) {
                    ASN1Primitive baseIdp;
                    X509CRL base = (X509CRL)it.next();
                    try {
                        baseIdp = PKIXCertPathReviewer.getExtensionValue(base, ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException ae6) {
                        ErrorBundle msg14 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(msg14, (Throwable)ae6);
                    }
                    if (idp == null) {
                        if (baseIdp != null) continue;
                        foundBase = true;
                        break;
                    }
                    if (!idp.equals(baseIdp)) continue;
                    foundBase = true;
                    break;
                }
                if (!foundBase) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException(msg6);
                }
            }
            if (idp != null) {
                ErrorBundle msg15;
                BasicConstraints bc2;
                IssuingDistributionPoint p2 = IssuingDistributionPoint.getInstance(idp);
                try {
                    bc2 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException ae7) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException(msg6, (Throwable)ae7);
                }
                if (p2.onlyContainsUserCerts() && bc2 != null && bc2.isCA()) {
                    msg15 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException(msg15);
                }
                if (p2.onlyContainsCACerts() && (bc2 == null || !bc2.isCA())) {
                    msg15 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException(msg15);
                }
                if (p2.onlyContainsAttributeCerts()) {
                    msg15 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException(msg15);
                }
            }
        }
        if (!validCrlFound) {
            ErrorBundle msg16 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(msg16);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint crlDistPoints) {
        Vector<String> urls = new Vector<String>();
        if (crlDistPoints != null) {
            DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
            for (int i2 = 0; i2 < distPoints.length; ++i2) {
                DistributionPointName dp_name = distPoints[i2].getDistributionPoint();
                if (dp_name.getType() != 0) continue;
                GeneralName[] generalNames = GeneralNames.getInstance(dp_name.getName()).getNames();
                for (int j2 = 0; j2 < generalNames.length; ++j2) {
                    if (generalNames[j2].getTagNo() != 6) continue;
                    String url = ((DERIA5String)generalNames[j2].getName()).getString();
                    urls.add(url);
                }
            }
        }
        return urls;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authInfoAccess) {
        Vector<String> urls = new Vector<String>();
        if (authInfoAccess != null) {
            AccessDescription[] ads = authInfoAccess.getAccessDescriptions();
            for (int i2 = 0; i2 < ads.length; ++i2) {
                GeneralName name;
                if (!ads[i2].getAccessMethod().equals(AccessDescription.id_ad_ocsp) || (name = ads[i2].getAccessLocation()).getTagNo() != 6) continue;
                String url = ((DERIA5String)name.getName()).getString();
                urls.add(url);
            }
        }
        return urls;
    }

    private X509CRL getCRL(String location) throws CertPathReviewerException {
        X509CRL result;
        block3: {
            result = null;
            try {
                URL url = new URL(location);
                if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) break block3;
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setUseCaches(false);
                conn.setDoInput(true);
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    CertificateFactory cf2 = CertificateFactory.getInstance("X.509", "BC");
                    result = (X509CRL)cf2.generateCRL(conn.getInputStream());
                    break block3;
                }
                throw new Exception(conn.getResponseMessage());
            }
            catch (Exception e2) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(location), e2.getMessage(), e2, e2.getClass().getName()});
                throw new CertPathReviewerException(msg);
            }
        }
        return result;
    }

    protected Collection getTrustAnchors(X509Certificate cert, Set trustanchors) throws CertPathReviewerException {
        ArrayList<TrustAnchor> trustColl = new ArrayList<TrustAnchor>();
        Iterator it = trustanchors.iterator();
        X509CertSelector certSelectX509 = new X509CertSelector();
        try {
            certSelectX509.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert).getEncoded());
            byte[] ext = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            if (ext != null) {
                ASN1OctetString oct = (ASN1OctetString)ASN1Primitive.fromByteArray(ext);
                AuthorityKeyIdentifier authID = AuthorityKeyIdentifier.getInstance(ASN1Primitive.fromByteArray(oct.getOctets()));
                certSelectX509.setSerialNumber(authID.getAuthorityCertSerialNumber());
                byte[] keyID = authID.getKeyIdentifier();
                if (keyID != null) {
                    certSelectX509.setSubjectKeyIdentifier(new DEROctetString(keyID).getEncoded());
                }
            }
        }
        catch (IOException iOException) {
            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(msg);
        }
        while (it.hasNext()) {
            X500Principal caName;
            X500Principal certIssuer;
            TrustAnchor trust = (TrustAnchor)it.next();
            if (trust.getTrustedCert() != null) {
                if (!certSelectX509.match(trust.getTrustedCert())) continue;
                trustColl.add(trust);
                continue;
            }
            if (trust.getCAName() == null || trust.getCAPublicKey() == null || !(certIssuer = PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert)).equals(caName = new X500Principal(trust.getCAName()))) continue;
            trustColl.add(trust);
        }
        return trustColl;
    }
}

