/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.asymmetric.keypair;

import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;

public final class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random = null;

    public void initialize(int keysize, SecureRandom random) {
        if (256 != keysize) {
            throw new InvalidParameterException("SM2 keysize must be 256 bytes!");
        }
        this.random = random;
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        cfca.sadk.org.bouncycastle.crypto.generators.SM2KeyPairGenerator generator = new cfca.sadk.org.bouncycastle.crypto.generators.SM2KeyPairGenerator();
        generator.init(new ECKeyGenerationParameters(SM2Params.sm2DomainParameters, this.random));
        AsymmetricCipherKeyPair pair = generator.generateKeyPair();
        SM2PublicKey pubKey = new SM2PublicKey((ECPublicKeyParameters)pair.getPublic());
        SM2PrivateKey priKey = new SM2PrivateKey((ECPrivateKeyParameters)pair.getPrivate(), (ECPublicKeyParameters)pair.getPublic());
        return new KeyPair(pubKey, priKey);
    }
}

