/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.AccountIndividualApplyRequest;
import java.util.Map;
import java.util.UUID;

public class AccountIndividualApplyRequestMarshaller
implements RequestMarshaller<AccountIndividualApplyRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/individual/apply";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<AccountIndividualApplyRequest> marshall(AccountIndividualApplyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/individual/apply");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getName() != null) {
            internalRequest.addParameter("name", PrimitiveMarshallerUtils.marshalling((Object)request.getName(), (String)"String"));
        }
        if (request.getCertificateType() != null) {
            internalRequest.addParameter("certificateType", PrimitiveMarshallerUtils.marshalling((Object)request.getCertificateType().getValue(), (String)"String"));
        }
        if (request.getCertificateNo() != null) {
            internalRequest.addParameter("certificateNo", PrimitiveMarshallerUtils.marshalling((Object)request.getCertificateNo(), (String)"String"));
        }
        if (request.getPhone() != null) {
            internalRequest.addParameter("phone", PrimitiveMarshallerUtils.marshalling((Object)request.getPhone(), (String)"String"));
        }
        if (request.getFrontUrl() != null) {
            internalRequest.addParameter("frontUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getFrontUrl(), (String)"String"));
        }
        if (request.getContraryUrl() != null) {
            internalRequest.addParameter("contraryUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getContraryUrl(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static AccountIndividualApplyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static AccountIndividualApplyRequestMarshaller INSTANCE = new AccountIndividualApplyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

