/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.ExternalOrderRequest;
import java.util.Map;
import java.util.UUID;

public class ExternalOrderRequestMarshaller
implements RequestMarshaller<ExternalOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/external/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<ExternalOrderRequest> marshall(ExternalOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/external/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getChannelName() != null) {
            internalRequest.addParameter("channelName", PrimitiveMarshallerUtils.marshalling((Object)request.getChannelName(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getMerchantName() != null) {
            internalRequest.addParameter("merchantName", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantName(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getTrxDate() != null) {
            internalRequest.addParameter("trxDate", PrimitiveMarshallerUtils.marshalling((Object)request.getTrxDate(), (String)"String"));
        }
        if (request.getFinishDate() != null) {
            internalRequest.addParameter("finishDate", PrimitiveMarshallerUtils.marshalling((Object)request.getFinishDate(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getRealAmount() != null) {
            internalRequest.addParameter("realAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getRealAmount(), (String)"BigDecimal"));
        }
        if (request.getPayerUserId() != null) {
            internalRequest.addParameter("payerUserId", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerUserId(), (String)"String"));
        }
        if (request.getPayWay() != null) {
            internalRequest.addParameter("payWay", PrimitiveMarshallerUtils.marshalling((Object)request.getPayWay(), (String)"String"));
        }
        if (request.getPayCardNo() != null) {
            internalRequest.addParameter("payCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayCardNo(), (String)"String"));
        }
        if (request.getPayCardType() != null) {
            internalRequest.addParameter("payCardType", PrimitiveMarshallerUtils.marshalling((Object)request.getPayCardType(), (String)"String"));
        }
        if (request.getUserRequestIp() != null) {
            internalRequest.addParameter("userRequestIp", PrimitiveMarshallerUtils.marshalling((Object)request.getUserRequestIp(), (String)"String"));
        }
        if (request.getTrxType() != null) {
            internalRequest.addParameter("trxType", PrimitiveMarshallerUtils.marshalling((Object)request.getTrxType(), (String)"String"));
        }
        if (request.getBatchNo() != null) {
            internalRequest.addParameter("batchNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBatchNo(), (String)"String"));
        }
        if (request.getChannelExtInfo() != null) {
            internalRequest.addParameter("channelExtInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getChannelExtInfo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static ExternalOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static ExternalOrderRequestMarshaller INSTANCE = new ExternalOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

