/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.TransferB2bOrderRequest;
import java.util.Map;
import java.util.UUID;

public class TransferB2bOrderRequestMarshaller
implements RequestMarshaller<TransferB2bOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/transfer/b2b/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<TransferB2bOrderRequest> marshall(TransferB2bOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/transfer/b2b/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getFromMerchantNo() != null) {
            internalRequest.addParameter("fromMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getFromMerchantNo(), (String)"String"));
        }
        if (request.getToMerchantNo() != null) {
            internalRequest.addParameter("toMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getToMerchantNo(), (String)"String"));
        }
        if (request.getToAccountType() != null) {
            internalRequest.addParameter("toAccountType", PrimitiveMarshallerUtils.marshalling((Object)request.getToAccountType(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"String"));
        }
        if (request.getUsage() != null) {
            internalRequest.addParameter("usage", PrimitiveMarshallerUtils.marshalling((Object)request.getUsage(), (String)"String"));
        }
        if (request.getFeeChargeSide() != null) {
            internalRequest.addParameter("feeChargeSide", PrimitiveMarshallerUtils.marshalling((Object)request.getFeeChargeSide(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TransferB2bOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TransferB2bOrderRequestMarshaller INSTANCE = new TransferB2bOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

