/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.auth.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.auth.request.FaceAuthKycRequest;
import java.util.Map;
import java.util.UUID;

public class FaceAuthKycRequestMarshaller
implements RequestMarshaller<FaceAuthKycRequest> {
    private final String serviceName = "Auth";
    private final String resourcePath = "/rest/v1.0/auth/face-auth-kyc";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<FaceAuthKycRequest> marshall(FaceAuthKycRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Auth");
        internalRequest.setResourcePath("/rest/v1.0/auth/face-auth-kyc");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getName() != null) {
            internalRequest.addParameter("name", PrimitiveMarshallerUtils.marshalling((Object)request.getName(), (String)"String"));
        }
        if (request.getCardNo() != null) {
            internalRequest.addParameter("cardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getCardNo(), (String)"String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling((Object)request.getCardType(), (String)"String"));
        }
        if (request.getReturnUrl() != null) {
            internalRequest.addParameter("returnUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getReturnUrl(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getExtraData() != null) {
            internalRequest.addParameter("extraData", PrimitiveMarshallerUtils.marshalling((Object)request.getExtraData(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static FaceAuthKycRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static FaceAuthKycRequestMarshaller INSTANCE = new FaceAuthKycRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

