/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.bill.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.bill.request.DownloadRequest;
import java.util.Map;
import java.util.UUID;

public class DownloadRequestMarshaller
implements RequestMarshaller<DownloadRequest> {
    private final String serviceName = "Bill";
    private final String resourcePath = "/yos/v1.0/bill/download";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<DownloadRequest> marshall(DownloadRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Bill");
        internalRequest.setResourcePath("/yos/v1.0/bill/download");
        internalRequest.setHttpMethod(this.httpMethodName);
        internalRequest.assignYos();
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getBizType() != null) {
            internalRequest.addParameter("bizType", PrimitiveMarshallerUtils.marshalling((Object)request.getBizType(), (String)"String"));
        }
        if (request.getBillDate() != null) {
            internalRequest.addParameter("billDate", PrimitiveMarshallerUtils.marshalling((Object)request.getBillDate(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static DownloadRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static DownloadRequestMarshaller INSTANCE = new DownloadRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

