/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.cashier.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.cashier.request.UnifiedOrderRequest;
import java.util.Map;
import java.util.UUID;

public class UnifiedOrderRequestMarshaller
implements RequestMarshaller<UnifiedOrderRequest> {
    private final String serviceName = "Cashier";
    private final String resourcePath = "/rest/v1.0/cashier/unified/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<UnifiedOrderRequest> marshall(UnifiedOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Cashier");
        internalRequest.setResourcePath("/rest/v1.0/cashier/unified/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getReturnUrl() != null) {
            internalRequest.addParameter("returnUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getReturnUrl(), (String)"String"));
        }
        if (request.getCsNotifyUrl() != null) {
            internalRequest.addParameter("csNotifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsNotifyUrl(), (String)"String"));
        }
        if (request.getBusinessInfo() != null) {
            internalRequest.addParameter("businessInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessInfo(), (String)"String"));
        }
        if (request.getPayerInfo() != null) {
            internalRequest.addParameter("payerInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerInfo(), (String)"String"));
        }
        if (request.getLimitPayType() != null) {
            internalRequest.addParameter("limitPayType", PrimitiveMarshallerUtils.marshalling((Object)request.getLimitPayType(), (String)"String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling((Object)request.getCardType(), (String)"String"));
        }
        if (request.getAggParam() != null) {
            internalRequest.addParameter("aggParam", PrimitiveMarshallerUtils.marshalling((Object)request.getAggParam(), (String)"String"));
        }
        if (request.getNoCardParam() != null) {
            internalRequest.addParameter("noCardParam", PrimitiveMarshallerUtils.marshalling((Object)request.getNoCardParam(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static UnifiedOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static UnifiedOrderRequestMarshaller INSTANCE = new UnifiedOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

