/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.cnppay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.cnppay.request.InstallmentPayRequestRequest;
import java.util.Map;
import java.util.UUID;

public class InstallmentPayRequestRequestMarshaller
implements RequestMarshaller<InstallmentPayRequestRequest> {
    private final String serviceName = "Cnppay";
    private final String resourcePath = "/rest/v1.0/cnppay/installment/pay/request";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<InstallmentPayRequestRequest> marshall(InstallmentPayRequestRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Cnppay");
        internalRequest.setResourcePath("/rest/v1.0/cnppay/installment/pay/request");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getBankId() != null) {
            internalRequest.addParameter("bankId", PrimitiveMarshallerUtils.marshalling((Object)request.getBankId(), (String)"String"));
        }
        if (request.getExpireTime() != null) {
            internalRequest.addParameter("expireTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpireTime(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getNumOfInstallment() != null) {
            internalRequest.addParameter("numOfInstallment", PrimitiveMarshallerUtils.marshalling((Object)request.getNumOfInstallment(), (String)"Integer"));
        }
        if (request.getRiskInfo() != null) {
            internalRequest.addParameter("riskInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getRiskInfo(), (String)"String"));
        }
        if (request.getRedirectUrl() != null) {
            internalRequest.addParameter("redirectUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getRedirectUrl(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getCsUrl() != null) {
            internalRequest.addParameter("csUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static InstallmentPayRequestRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static InstallmentPayRequestRequestMarshaller INSTANCE = new InstallmentPayRequestRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

