/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.facepay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.facepay.request.FacepayProxyBindFirstCardRequest;
import java.util.Map;
import java.util.UUID;

public class FacepayProxyBindFirstCardRequestMarshaller
implements RequestMarshaller<FacepayProxyBindFirstCardRequest> {
    private final String serviceName = "Facepay";
    private final String resourcePath = "/rest/v1.0/facepay/facepay-proxy/bind-first-card";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<FacepayProxyBindFirstCardRequest> marshall(FacepayProxyBindFirstCardRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Facepay");
        internalRequest.setResourcePath("/rest/v1.0/facepay/facepay-proxy/bind-first-card");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCardNo(), (String)"String"));
        }
        if (request.getPhoneNumber() != null) {
            internalRequest.addParameter("phoneNumber", PrimitiveMarshallerUtils.marshalling((Object)request.getPhoneNumber(), (String)"String"));
        }
        if (request.getCvv2() != null) {
            internalRequest.addParameter("cvv2", PrimitiveMarshallerUtils.marshalling((Object)request.getCvv2(), (String)"String"));
        }
        if (request.getExpireDate() != null) {
            internalRequest.addParameter("expireDate", PrimitiveMarshallerUtils.marshalling((Object)request.getExpireDate(), (String)"String"));
        }
        if (request.getBizNo() != null) {
            internalRequest.addParameter("bizNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBizNo(), (String)"String"));
        }
        if (request.getBizToken() != null) {
            internalRequest.addParameter("bizToken", PrimitiveMarshallerUtils.marshalling((Object)request.getBizToken(), (String)"String"));
        }
        if (request.getBizSystem() != null) {
            internalRequest.addParameter("bizSystem", PrimitiveMarshallerUtils.marshalling((Object)request.getBizSystem(), (String)"String"));
        }
        if (request.getMtToken() != null) {
            internalRequest.addParameter("mtToken", PrimitiveMarshallerUtils.marshalling((Object)request.getMtToken(), (String)"String"));
        }
        if (request.getMemberNo() != null) {
            internalRequest.addParameter("memberNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemberNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static FacepayProxyBindFirstCardRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static FacepayProxyBindFirstCardRequestMarshaller INSTANCE = new FacepayProxyBindFirstCardRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

