/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.facepay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.facepay.request.OAuth2TokenGenerateTokenRequest;
import java.util.Map;
import java.util.UUID;

public class OAuth2TokenGenerateTokenRequestMarshaller
implements RequestMarshaller<OAuth2TokenGenerateTokenRequest> {
    private final String serviceName = "Facepay";
    private final String resourcePath = "/rest/v1.0/facepay/o-auth2-token/generate-token";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<OAuth2TokenGenerateTokenRequest> marshall(OAuth2TokenGenerateTokenRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Facepay");
        internalRequest.setResourcePath("/rest/v1.0/facepay/o-auth2-token/generate-token");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getUserId() != null) {
            internalRequest.addParameter("userId", PrimitiveMarshallerUtils.marshalling((Object)request.getUserId(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static OAuth2TokenGenerateTokenRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static OAuth2TokenGenerateTokenRequestMarshaller INSTANCE = new OAuth2TokenGenerateTokenRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

