/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.frontcashier.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.frontcashier.request.BindcardRequestV2Request;
import java.util.Map;
import java.util.UUID;

public class BindcardRequestV2RequestMarshaller
implements RequestMarshaller<BindcardRequestV2Request> {
    private final String serviceName = "Frontcashier";
    private final String resourcePath = "/rest/v2.0/frontcashier/bindcard/request";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<BindcardRequestV2Request> marshall(BindcardRequestV2Request request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Frontcashier");
        internalRequest.setResourcePath("/rest/v2.0/frontcashier/bindcard/request");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getMerchantFlowId() != null) {
            internalRequest.addParameter("merchantFlowId", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantFlowId(), (String)"String"));
        }
        if (request.getUserNo() != null) {
            internalRequest.addParameter("userNo", PrimitiveMarshallerUtils.marshalling((Object)request.getUserNo(), (String)"String"));
        }
        if (request.getUserType() != null) {
            internalRequest.addParameter("userType", PrimitiveMarshallerUtils.marshalling((Object)request.getUserType(), (String)"String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCardNo(), (String)"String"));
        }
        if (request.getUserName() != null) {
            internalRequest.addParameter("userName", PrimitiveMarshallerUtils.marshalling((Object)request.getUserName(), (String)"String"));
        }
        if (request.getIdCardNo() != null) {
            internalRequest.addParameter("idCardNo", PrimitiveMarshallerUtils.marshalling((Object)request.getIdCardNo(), (String)"String"));
        }
        if (request.getPhone() != null) {
            internalRequest.addParameter("phone", PrimitiveMarshallerUtils.marshalling((Object)request.getPhone(), (String)"String"));
        }
        if (request.getCvv2() != null) {
            internalRequest.addParameter("cvv2", PrimitiveMarshallerUtils.marshalling((Object)request.getCvv2(), (String)"String"));
        }
        if (request.getValidthru() != null) {
            internalRequest.addParameter("validthru", PrimitiveMarshallerUtils.marshalling((Object)request.getValidthru(), (String)"String"));
        }
        if (request.getOrderValidate() != null) {
            internalRequest.addParameter("orderValidate", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderValidate(), (String)"Integer"));
        }
        if (request.getAuthType() != null) {
            internalRequest.addParameter("authType", PrimitiveMarshallerUtils.marshalling((Object)request.getAuthType(), (String)"String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling((Object)request.getCardType(), (String)"String"));
        }
        if (request.getIsSMS() != null) {
            internalRequest.addParameter("isSMS", PrimitiveMarshallerUtils.marshalling((Object)request.getIsSMS(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BindcardRequestV2RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BindcardRequestV2RequestMarshaller INSTANCE = new BindcardRequestV2RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

