/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.m_wallet.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.m_wallet.request.AccountOpenNotifyRequest;
import java.util.Map;
import java.util.UUID;

public class AccountOpenNotifyRequestMarshaller
implements RequestMarshaller<AccountOpenNotifyRequest> {
    private final String serviceName = "MWallet";
    private final String resourcePath = "/rest/v1.0/m-wallet/account/open/notify";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<AccountOpenNotifyRequest> marshall(AccountOpenNotifyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "MWallet");
        internalRequest.setResourcePath("/rest/v1.0/m-wallet/account/open/notify");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getMerchantUserNo() != null) {
            internalRequest.addParameter("merchantUserNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantUserNo(), (String)"String"));
        }
        if (request.getWalletUserNo() != null) {
            internalRequest.addParameter("walletUserNo", PrimitiveMarshallerUtils.marshalling((Object)request.getWalletUserNo(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getBusinessNo() != null) {
            internalRequest.addParameter("businessNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static AccountOpenNotifyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static AccountOpenNotifyRequestMarshaller INSTANCE = new AccountOpenNotifyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

