/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.m_wallet.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.m_wallet.request.BillQueryListRequest;
import java.util.Map;
import java.util.UUID;

public class BillQueryListRequestMarshaller
implements RequestMarshaller<BillQueryListRequest> {
    private final String serviceName = "MWallet";
    private final String resourcePath = "/rest/v1.0/m-wallet/bill/query-list";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<BillQueryListRequest> marshall(BillQueryListRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "MWallet");
        internalRequest.setResourcePath("/rest/v1.0/m-wallet/bill/query-list");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getMerchantUserNo() != null) {
            internalRequest.addParameter("merchantUserNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantUserNo(), (String)"String"));
        }
        if (request.getOrderType() != null) {
            internalRequest.addParameter("orderType", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderType().getValue(), (String)"String"));
        }
        if (request.getPage() != null) {
            internalRequest.addParameter("page", PrimitiveMarshallerUtils.marshalling((Object)request.getPage(), (String)"Integer"));
        }
        if (request.getPageNum() != null) {
            internalRequest.addParameter("pageNum", PrimitiveMarshallerUtils.marshalling((Object)request.getPageNum(), (String)"Integer"));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", PrimitiveMarshallerUtils.marshalling((Object)request.getEndTime(), (String)"DateTime"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BillQueryListRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BillQueryListRequestMarshaller INSTANCE = new BillQueryListRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

