/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.m_wallet.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.m_wallet.request.TradeOrderV2Request;
import java.util.Map;
import java.util.UUID;

public class TradeOrderV2RequestMarshaller
implements RequestMarshaller<TradeOrderV2Request> {
    private final String serviceName = "MWallet";
    private final String resourcePath = "/rest/v2.0/m-wallet/trade/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<TradeOrderV2Request> marshall(TradeOrderV2Request request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "MWallet");
        internalRequest.setResourcePath("/rest/v2.0/m-wallet/trade/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getCsUrl() != null) {
            internalRequest.addParameter("csUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getMemberNo() != null) {
            internalRequest.addParameter("memberNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemberNo(), (String)"String"));
        }
        if (request.getPayerIp() != null) {
            internalRequest.addParameter("payerIp", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerIp(), (String)"String"));
        }
        if (request.getPayAgreement() != null) {
            internalRequest.addParameter("payAgreement", PrimitiveMarshallerUtils.marshalling((Object)request.getPayAgreement(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TradeOrderV2RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TradeOrderV2RequestMarshaller INSTANCE = new TradeOrderV2RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

