/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.mer.request.ProductFeeQueryV2Request;
import java.util.Map;
import java.util.UUID;

public class ProductFeeQueryV2RequestMarshaller
implements RequestMarshaller<ProductFeeQueryV2Request> {
    private final String serviceName = "Mer";
    private final String resourcePath = "/rest/v2.0/mer/product/fee/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<ProductFeeQueryV2Request> marshall(ProductFeeQueryV2Request request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Mer");
        internalRequest.setResourcePath("/rest/v2.0/mer/product/fee/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getProductCode() != null) {
            internalRequest.addParameter("productCode", PrimitiveMarshallerUtils.marshalling((Object)request.getProductCode(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static ProductFeeQueryV2RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static ProductFeeQueryV2RequestMarshaller INSTANCE = new ProductFeeQueryV2RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

