/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.offline;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.offline.OfflineClient;
import com.yeepay.yop.sdk.service.offline.request.BindRequest;
import com.yeepay.yop.sdk.service.offline.request.BindRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.CreateShopRequest;
import com.yeepay.yop.sdk.service.offline.request.CreateShopRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.GetShopRequest;
import com.yeepay.yop.sdk.service.offline.request.GetShopRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.OperateShopRequest;
import com.yeepay.yop.sdk.service.offline.request.OperateShopRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.QueryAgentListRequest;
import com.yeepay.yop.sdk.service.offline.request.QueryAgentListRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.QueryShopBindListRequest;
import com.yeepay.yop.sdk.service.offline.request.QueryShopBindListRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.UnbindRequest;
import com.yeepay.yop.sdk.service.offline.request.UnbindRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.request.UpdateShopRequest;
import com.yeepay.yop.sdk.service.offline.request.UpdateShopRequestMarshaller;
import com.yeepay.yop.sdk.service.offline.response.BindResponse;
import com.yeepay.yop.sdk.service.offline.response.CreateShopResponse;
import com.yeepay.yop.sdk.service.offline.response.GetShopResponse;
import com.yeepay.yop.sdk.service.offline.response.OperateShopResponse;
import com.yeepay.yop.sdk.service.offline.response.QueryAgentListResponse;
import com.yeepay.yop.sdk.service.offline.response.QueryShopBindListResponse;
import com.yeepay.yop.sdk.service.offline.response.UnbindResponse;
import com.yeepay.yop.sdk.service.offline.response.UpdateShopResponse;

public class OfflineClientImpl
implements OfflineClient {
    private final ClientHandler clientHandler;

    OfflineClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public BindResponse bind(BindRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        BindRequestMarshaller requestMarshaller = BindRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(BindResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (BindResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public CreateShopResponse createShop(CreateShopRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        CreateShopRequestMarshaller requestMarshaller = CreateShopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(CreateShopResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (CreateShopResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public GetShopResponse getShop(GetShopRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        GetShopRequestMarshaller requestMarshaller = GetShopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(GetShopResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (GetShopResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public OperateShopResponse operateShop(OperateShopRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        OperateShopRequestMarshaller requestMarshaller = OperateShopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OperateShopResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OperateShopResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public QueryAgentListResponse queryAgentList(QueryAgentListRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getAgentMerchantNo() == null) {
            throw new YopClientException("request.agentMerchantNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        QueryAgentListRequestMarshaller requestMarshaller = QueryAgentListRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(QueryAgentListResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (QueryAgentListResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public QueryShopBindListResponse queryShopBindList(QueryShopBindListRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getShopNo() == null) {
            throw new YopClientException("request.shopNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        QueryShopBindListRequestMarshaller requestMarshaller = QueryShopBindListRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(QueryShopBindListResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (QueryShopBindListResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public UnbindResponse unbind(UnbindRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        UnbindRequestMarshaller requestMarshaller = UnbindRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(UnbindResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (UnbindResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public UpdateShopResponse updateShop(UpdateShopRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        UpdateShopRequestMarshaller requestMarshaller = UpdateShopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(UpdateShopResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (UpdateShopResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

