/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.offline.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.offline.request.GetShopRequest;
import java.util.Map;
import java.util.UUID;

public class GetShopRequestMarshaller
implements RequestMarshaller<GetShopRequest> {
    private final String serviceName = "Offline";
    private final String resourcePath = "/rest/v1.0/offline/get-shop";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<GetShopRequest> marshall(GetShopRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Offline");
        internalRequest.setResourcePath("/rest/v1.0/offline/get-shop");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getShopName() != null) {
            internalRequest.addParameter("shopName", PrimitiveMarshallerUtils.marshalling((Object)request.getShopName(), (String)"String"));
        }
        if (request.getShopNo() != null) {
            internalRequest.addParameter("shopNo", PrimitiveMarshallerUtils.marshalling((Object)request.getShopNo(), (String)"String"));
        }
        if (request.getStatus() != null) {
            internalRequest.addParameter("status", PrimitiveMarshallerUtils.marshalling((Object)request.getStatus(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static GetShopRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static GetShopRequestMarshaller INSTANCE = new GetShopRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

