/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.offline.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.offline.request.QueryAgentListRequest;
import java.util.Map;
import java.util.UUID;

public class QueryAgentListRequestMarshaller
implements RequestMarshaller<QueryAgentListRequest> {
    private final String serviceName = "Offline";
    private final String resourcePath = "/rest/v1.0/offline/query-agent-list";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<QueryAgentListRequest> marshall(QueryAgentListRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Offline");
        internalRequest.setResourcePath("/rest/v1.0/offline/query-agent-list");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getAgentMerchantNo() != null) {
            internalRequest.addParameter("agentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getAgentMerchantNo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getTerminalNo() != null) {
            internalRequest.addParameter("terminalNo", PrimitiveMarshallerUtils.marshalling((Object)request.getTerminalNo(), (String)"String"));
        }
        if (request.getSerialNo() != null) {
            internalRequest.addParameter("serialNo", PrimitiveMarshallerUtils.marshalling((Object)request.getSerialNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static QueryAgentListRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static QueryAgentListRequestMarshaller INSTANCE = new QueryAgentListRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

