/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.p2f.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.p2f.request.CompanyFinanceRedeemOrderRequest;
import java.util.Map;
import java.util.UUID;

public class CompanyFinanceRedeemOrderRequestMarshaller
implements RequestMarshaller<CompanyFinanceRedeemOrderRequest> {
    private final String serviceName = "P2f";
    private final String resourcePath = "/rest/v1.0/p2f/company-finance/redeem-order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<CompanyFinanceRedeemOrderRequest> marshall(CompanyFinanceRedeemOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "P2f");
        internalRequest.setResourcePath("/rest/v1.0/p2f/company-finance/redeem-order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getP2fOpenAcctNo() != null) {
            internalRequest.addParameter("p2fOpenAcctNo", PrimitiveMarshallerUtils.marshalling((Object)request.getP2fOpenAcctNo(), (String)"String"));
        }
        if (request.getProdCode() != null) {
            internalRequest.addParameter("prodCode", PrimitiveMarshallerUtils.marshalling((Object)request.getProdCode(), (String)"String"));
        }
        if (request.getAmount() != null) {
            internalRequest.addParameter("amount", PrimitiveMarshallerUtils.marshalling((Object)request.getAmount(), (String)"BigDecimal"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getChannelCode() != null) {
            internalRequest.addParameter("channelCode", PrimitiveMarshallerUtils.marshalling((Object)request.getChannelCode(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getP2fOrderId() != null) {
            internalRequest.addParameter("p2fOrderId", PrimitiveMarshallerUtils.marshalling((Object)request.getP2fOrderId(), (String)"String"));
        }
        if (request.getRequestTime() != null) {
            internalRequest.addParameter("requestTime", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestTime(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static CompanyFinanceRedeemOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static CompanyFinanceRedeemOrderRequestMarshaller INSTANCE = new CompanyFinanceRedeemOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

