/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.p2f.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.p2f.request.FileUploadRequest;
import java.util.Map;
import java.util.UUID;

public class FileUploadRequestMarshaller
implements RequestMarshaller<FileUploadRequest> {
    private final String serviceName = "P2f";
    private final String resourcePath = "/yos/v1.0/p2f/file-upload";
    private final String contentType = "multipart/form-data";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<FileUploadRequest> marshall(FileUploadRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "P2f");
        internalRequest.setResourcePath("/yos/v1.0/p2f/file-upload");
        internalRequest.setHttpMethod(this.httpMethodName);
        internalRequest.assignYos();
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getIdentityType() != null) {
            internalRequest.addParameter("identityType", PrimitiveMarshallerUtils.marshalling((Object)request.getIdentityType(), (String)"String"));
        }
        if (request.getIdentityId() != null) {
            internalRequest.addParameter("identityId", PrimitiveMarshallerUtils.marshalling((Object)request.getIdentityId(), (String)"String"));
        }
        if (request.getIdType() != null) {
            internalRequest.addParameter("idType", PrimitiveMarshallerUtils.marshalling((Object)request.getIdType(), (String)"String"));
        }
        if (request.getIdNO() != null) {
            internalRequest.addParameter("idNO", PrimitiveMarshallerUtils.marshalling((Object)request.getIdNO(), (String)"String"));
        }
        if (request.getFileType() != null) {
            internalRequest.addParameter("fileType", PrimitiveMarshallerUtils.marshalling((Object)request.getFileType(), (String)"String"));
        }
        if (request.getImage() != null) {
            internalRequest.addMultiPartFile("image", request.getImage());
        }
        internalRequest.setContentType(YopContentType.MULTIPART_FORM);
        return internalRequest;
    }

    public static FileUploadRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static FileUploadRequestMarshaller INSTANCE = new FileUploadRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

