/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.tel_pay;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.tel_pay.TelPayClient;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeBatchGenerateRequest;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeBatchGenerateRequestMarshaller;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeQueryRequest;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.tel_pay.response.QrcodeBatchGenerateResponse;
import com.yeepay.yop.sdk.service.tel_pay.response.QrcodeQueryResponse;

public class TelPayClientImpl
implements TelPayClient {
    private final ClientHandler clientHandler;

    TelPayClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public QrcodeBatchGenerateResponse qrcodeBatchGenerate(QrcodeBatchGenerateRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        QrcodeBatchGenerateRequestMarshaller requestMarshaller = QrcodeBatchGenerateRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(QrcodeBatchGenerateResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (QrcodeBatchGenerateResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public QrcodeQueryResponse qrcodeQuery(QrcodeQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getRequestId() == null) {
            throw new YopClientException("request.requestId is required.");
        }
        if (request.getPageSize() == null) {
            throw new YopClientException("request.pageSize is required.");
        }
        if (request.getPageNo() == null) {
            throw new YopClientException("request.pageNo is required.");
        }
        QrcodeQueryRequestMarshaller requestMarshaller = QrcodeQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(QrcodeQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (QrcodeQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

